﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;

namespace PWS.API.Menu
{
    public class MenuAPI
    {
		#region Fields (34) 

        public int baseCommandId = 0xf200;
 // Start menu id's from here
        public int currentIndex = 0;
public const int MF_BYPOSITION = 0x400;
        public const int MF_CHECKED = 0x8;
        public const int MF_DISABLED = 0x2;
        public const int MF_GRAYED = 0x1;
        public const int MF_REMOVE = 0x1000;
        public const int MF_SEPARATOR = 0x800;
        public const int MF_STRING = 0x0;
        public const int MFS_Enabled = 0x0;
        public const int MFT_String = 0x0;
        public const int MIIM_Checkmarks = 0x8;
        public const int MIIM_Data = 0x20;
        public const int MIIM_Id = 0x2;
        public const int MIIM_State = 0x1;
        public const int MIIM_String = 0x40;
        public const int MIIM_SunMenu = 0x4;
        public const int MIIM_Type = 0x100;
        //vertically
        public int TPM_BotoomAlign = 0x0020;
        //horizontally
        public int TPM_CentralAlign = 0x0004;
        // Animation
        public int TPM_HorNegAnimation = 0x0800;
        public int TPM_HorPosAnimation = 0x0400;
        public int TPM_LeftAlign = 0x0000;
        //MouseClick
        public int TPM_LeftButton = 0x0000;
        public int TPM_NoAnimation = 0x4000;
        //Control Menu
        public int TPM_NoNotify = 0x0080;
        public int TPM_ReturnCmd = 0x0100;
        public int TPM_RightAlign = 0x0008;
        public int TPM_RightButton = 0x0002;
        public int TPM_TopAlign = 0x0000;
        public int TPM_VCenterAlign = 0x0010;
        public int TPM_VerNegAnimation = 0x2000;
        public int TPM_VerPosAnimation = 0x1000;
        public const int WM_SYSCOMMAND = 0x112;

		#endregion Fields 

		#region Enums (1) 

        [Flags]
        public enum MenuFlags : uint
        {
            MF_Checked = 0x8,
            MF_Disabled = 0x2,
            MF_Grayed = 0x1,
            MF_Separator = 0x800,
            MF_String = 0x0,
            MF_Enabled = 0x0
        }

		#endregion Enums 

		#region Methods (25) 

		// Public Methods (25) 

        [DllImport("user32.dll", EntryPoint = "AppendMenuA")]
        public static extern bool AppendMenu(IntPtr hMenu, MenuFlags wFlags, IntPtr wIDNewItem, string lpNewItem);

        [DllImport("user32.dll")]
        public static extern bool CheckMenuRadioItem(IntPtr hmenu, uint idFirst, uint idLast, uint idCheck, uint uFlags);

        [DllImport("user32.dll")]
        public static extern IntPtr CreateMenu();

        [DllImport("user32", SetLastError = true)]
        public static extern IntPtr CreatePopupMenu();

        [DllImport("user32.dll")]
        public static extern bool DestroyMenu(IntPtr hMenu);

        [DllImport("user32.dll")]
        public static extern bool DrawMenuBar(IntPtr hWnd);

        [DllImport("user32.dll")]
        public static extern bool EndMenu();

        /// <summary>
        /// mohasebe tedad item hay menu
        /// </summary>
        /// <param name="hMenu">handle menu morde nazar</param>
        /// <returns>tedad item hay menu</returns>
        [DllImport("user32.dll")]
        public static extern int GetMenuItemCount(IntPtr hMenu);

        /// <summary>
        ///
        /// </summary>
        /// <param name="hMenu"></param>
        /// <param name="nPosition"></param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern IntPtr GetMenuItemID(IntPtr hMenu, int nPosition);

        [DllImport("user32.dll", SetLastError = true)]
        public static extern bool GetMenuItemInfo(IntPtr hMenu, int uItem, bool fByPosition, ref MenuItemInfo lpmii);

        [DllImport("user32.dll", SetLastError = true)]
        public static extern bool GetMenuItemInfo(IntPtr hMenu, int uItem, int fByPosition, ref MenuItemInfo lpmii);

        [DllImport("user32.dll")]
        public static extern bool GetMenuItemRect(IntPtr hWnd, IntPtr hMenu, uint uItem, out Rectangle lprcItem);

        [DllImport("user32.dll", SetLastError = true)]
        public static extern IntPtr GetSubMenu(IntPtr hMenu, int nPos);

        /// <summary>
        /// tabe handle menu
        /// </summary>
        /// <param name="hwnd">handle form</param>
        /// <param name="bRevert">xvc</param>
        /// <returns>handle menu system ra midahad</returns>
        [DllImport("user32.dll")]
        public static extern IntPtr GetSystemMenu(IntPtr hwnd, long bRevert);

        [DllImport("user32.dll", EntryPoint = "InsertMenuItemA", SetLastError = true)]
        public static extern bool InsertMenuItem(IntPtr hMenu, int uItem, bool fByPosition, [In] ref MenuItemInfo lpmii);

        [DllImport("user32.dll")]
        public static extern bool ModifyMenu(IntPtr hMnu, int uPosition, int uFlags, IntPtr uIDNewItem, string lpNewItem);

        [DllImport("user32.dll", SetLastError = true)]
        public static extern bool ModifyMenu(IntPtr hMnu, IntPtr uPosition, int uFlags, IntPtr uIDNewItem, string lpNewItem);

        /// <summary>
        ///
        /// </summary>
        /// <param name="hMenu"></param>
        /// <param name="nPosition"></param>
        /// <param name="wFlag"></param>
        /// <returns></returns>
        [DllImport("user32.dll")]
        public static extern bool RemoveMenu(IntPtr hMenu, int nPosition, int wFlag);

        [DllImport("user32.dll")]
        public static extern bool SetMenu(IntPtr hWnd, IntPtr hMenu);

        [DllImport("user32.dll")]
        public static extern bool SetMenuItemBitmaps(IntPtr hMenu, int nPosition, int wFlags, IntPtr hBitmapUnchecked, IntPtr hBitmapChecked);

        [DllImport("user32.dll")]
        public static extern bool SetMenuItemInfo(IntPtr hMenu, int nPositin, int wFlags, [In] ref MenuItemInfo lpmii);

        [DllImport("user32.dll")]
        public static extern int TrackPopupMenuEx(IntPtr hMenu, int uFlags, int x, int y, IntPtr hwnd, IntPtr lptpm);

		#endregion Methods 


        [StructLayout(LayoutKind.Sequential)]
        public struct MenuItemInfo
        {
		#region Data Members (13) 

            public uint cbSize;
            public uint cch;
            public IntPtr dwItemData;
            public String dwTypeData;
            public uint fMask;
            public uint fState;
            public uint fType;
            public IntPtr hbmpChecked;
            public IntPtr hbmpItem;
            public IntPtr hbmpUnchecked;
            public IntPtr hSubMenu;
            public uint wID;
            // Return the size of the structure
            public static uint SizeOf
            {
                get { return (uint)Marshal.SizeOf(typeof(MenuItemInfo)); }
            }

		#endregion Data Members 
        }
    }
}